// TOPWAY Smart LCD interface with Arduino UNO
// convert analog input value to the Smart LCD as VU meter
// Arduino UNO code used in video (for reference only)

// Logarithmic Look-Up-Table (0~255 --> 0~241)
int LUT_LOG[]= {
    0,  0, 30, 48, 60, 70, 78, 85, 90, 95,100,104,108,111,115,118,
  120,123,126,128,130,132,134,136,138,140,141,143,145,146,148,149,
  151,152,153,154,156,157,158,159,160,161,162,163,164,165,166,167,
  168,169,170,171,172,172,173,174,175,176,176,177,178,179,179,180,
  181,181,182,183,183,184,185,185,186,186,187,188,188,189,189,190,
  190,191,191,192,192,193,193,194,194,195,195,196,196,197,197,198,
  198,199,199,200,200,200,201,201,202,202,203,203,203,204,204,205,
  205,205,206,206,206,207,207,208,208,208,209,209,209,210,210,210,
  211,211,211,212,212,212,213,213,213,214,214,214,215,215,215,216,
  216,216,216,217,217,217,218,218,218,218,219,219,219,220,220,220,
  220,221,221,221,221,222,222,222,223,223,223,223,224,224,224,224,
  225,225,225,225,226,226,226,226,226,227,227,227,227,228,228,228,
  228,229,229,229,229,229,230,230,230,230,231,231,231,231,231,232,
  232,232,232,232,233,233,233,233,233,234,234,234,234,234,235,235,
  235,235,235,236,236,236,236,236,237,237,237,237,237,237,238,238,
  238,238,238,239,239,239,239,239,239,240,240,240,240,240,240,241};

short AD_L, AD_R, abs_L, abs_R, temp;
short Disp_L, Disp_R, Peak_L, Peak_R; // converted display value
char AIN_L=1; // define analog channel
char AIN_R=2;

void setup() {
  // start serial port at 115200 bps:
  Serial.begin(115200);
  while (!Serial) {
  ;} // wait for serial port to connect. Needed for native USB port only  
  }

void loop() {
  AD_L = analogRead(AIN_L);     // AD value (0~1023)
  AD_R = analogRead(AIN_R); 
  
  if (AD_L < 257) {AD_L = 257;} // limit the value (512 +/-255)
  if (AD_R < 257) {AD_R = 257;}
  if (AD_L > 767) {AD_L = 767;}
  if (AD_R > 767) {AD_R = 767;}

  abs_L = abs(AD_L - 512);  // offset the bais, get amplitude (0~255)
  abs_R = abs(AD_R - 512);  

  Peak_L = Peak_L-1;        // slowly dec the peak value for display
  Peak_R = Peak_R-1;        // slowly dec the peak value for display
  Disp_L = Disp_L-10;       // fastly dec the disp value for display
  Disp_R = Disp_R-10;       // fastly dec the disp value for display
  
  temp = LUT_LOG[abs_L]; 
  if (temp > Disp_L) {Disp_L = temp;}     // mimic the peak in Log Scale
  temp = LUT_LOG[abs_R];
  if (temp > Disp_R) {Disp_R = temp;}

  if (Disp_L > Peak_L) {Peak_L = Disp_L;} // mimic the peak in Log Scale
  if (Disp_R > Peak_R) {Peak_R = Disp_R;}

  // send values to SmartLCD VP(0x080000~0x80006)
  Serial.write(0xaa);             // packet head
  Serial.write(0x82);             // Successive_write command
  Serial.write(0x00);             // VP_N16 start address
  Serial.write(0x08);
  Serial.write(0x00);
  Serial.write(0x00);
  Serial.write(0x04);             // write 4 16bit data
  Serial.write(highByte(Disp_L)); // VP_N16 data high byte
  Serial.write(lowByte (Disp_L)); // VP_N16 data low byte
  Serial.write(highByte(Disp_R)); // VP_N16 data high byte
  Serial.write(lowByte (Disp_R)); // VP_N16 data low byte
  Serial.write(highByte(Peak_L)); // VP_N16 data high byte
  Serial.write(lowByte (Peak_L)); // VP_N16 data low byte
  Serial.write(highByte(Peak_R)); // VP_N16 data high byte
  Serial.write(lowByte (Peak_R)); // VP_N16 data low byte
  Serial.write(0xcc);             // packet tail
  Serial.write(0x33);             // packet tail
  Serial.write(0xc3);             // packet tail
  Serial.write(0x3c);             // packet tail

  for (int i = 0; i < 20; i++) {delayMicroseconds(1000);}
}
