-- define a VP_N16[0x080000] as MODBUS fetcch value
-- define VP_G16[0x060000](array=150)
-- build a graph element on screen link to 0x060000 

-- define variable(s)
GRAPH_CMD = {0x4E, 0x00, 0x06, 0x00, 0x00, 0x00, 0x96, 0x00, 0x00}
-- 0x4e; command head
-- 0x00, 0x06, 0x00, 0x00; VP_G16 add
-- 0x00, 0x96; total no of data
-- 0x00, 0x00: data
INVALID = -32767

loop_speed=150
loop_tic=hmt.gettick()
temp=0


-- main loop
luamain = function(void)
  -- looping control
  temp=hmt.gettick() - loop_tic
  if ((temp >= loop_speed) or (temp < 0)) then

    -- get the value form a VP
    a_value = hmt.readvp16(0x080002)
    b_value = hmt.readvp16(0x080004)
    c_value = hmt.readvp16(0x080006)

    -- check the bits
    if ((a_value + b_value + c_value)==10)
    then unlocked=1
    else unlocked=0
    end

    hmt.writevp16(0x080000, unlocked)

    -- refresh the Smart LCD VP_G16 by command
    temp = hmt.readvp16(0x080008)
    GRAPH_CMD[8] = temp >> 8
    GRAPH_CMD[9] = temp &  0x00ff
    hmt.runcmd(GRAPH_CMD, 9)

    hmt.writevp32(0x020000, loop_tic)
    loop_tic=hmt.gettick()
  end

  return 0

end

-- Lua script end